-- Weather Underground to Apple //
-- 2011 Kevin Dady
--  
-- Text to Graphics:
-- take text from web.data
-- make text images with image magick
-- phrase *.xpm files to apple //
-- send text images 
-- end
text = {}
	text.data = {}
		text.data.input  = {}
		text.data.packed = {{},{},{},{}}
		text.data.apl2   = {{},{},{}}

text.createIMG = function()
	if web.data[1] == nil then
		web.data[1] = "No Advisories"
	end
	if web.data[3] == nil then
		web.data[3] = web.data[7] 
	end
	-- create the bottom text
	cmd.imageMGK(" -background black -fill white -font req/VeraMoBd.ttf"..
	" -dither none -map req/mono.xpm -size 279x53 -pointsize 11 -gravity West"..
	" caption:'".. web.data[2].."\n"..web.data[6].."\n"..web.data[5].."\n"..web.data[3].. "'"..
	" temp/textBTM.xpm")
	-- create the text for advisories
	cmd.imageMGK(" -background black -fill white -font req/VeraMoBd.ttf"..
	" -dither none -map req/mono.xpm -size 139x64 -pointsize 11 -gravity Center"..
	" caption:'".. web.data[1].."'"..
	" temp/textALT.xpm")
	-- create the text for temperature
	cmd.imageMGK(" -background black -fill white -font req/VeraMoBd.ttf"..
	" -dither none -map req/mono.xpm -size 139x74 -pointsize 36 -gravity Center"..
	" caption:'".. web.data[4].."'"..
	" temp/textTMP.xpm")
end

text.convertIMG = function()
	local files  = {"textTMP.xpm","textALT.xpm","textBTM.xpm"}
	local footer = {82,72,61}
	local width  = {140,140,280}
	 -- read the files into a table one at a time
	for img = 1, 3 do
		local file = io.open("temp/".. files[img],"r")
		table.insert(text.data.input, img, {})
		for line in file:lines() do
			table.insert(text.data.input[img], tostring(line))
		end
		file:close()
		-- remove header
		for y = 1, 7 do 
			table.remove(text.data.input[img], 1)
		end
		-- remove footer
 		table.remove(text.data.input[img], footer[img] - 7)
		-- remove non pixel data
		for y = 1, #text.data.input[img] do
			text.data.input[img][y] = string.sub(text.data.input[img][y], 2, width[img])
		end
	end
end

text.sortIMG = function()
	local newChar = ""
	for img = 1, 3 do
		-- need to convert the strings into tables
		for y = 1, #text.data.input[img] do
			table.insert(text.data.apl2[img], {})
			-- for each column in the current row
			for x = 1, #text.data.input[img][y] do
				-- read the character at that Y,X point
				newChar = string.sub(text.data.input[img][y], x,x)	
				if newChar == "." then 
					table.insert(text.data.apl2[img][y], x) -- pixel
				end
			end
		end
	end 
end

text.packageIMG = function()
	for img = 1, 2 do	
		for y = 1, #text.data.input[img] do
			local one   = ""
			local two   = ""
			local three = ""
			local four  = ""
			for x = 1, #text.data.apl2[img][y] do
				if text.data.apl2[img][y][x] <= 35 then
						one = one .. string.sub(graphicsKey, text.data.apl2[img][y][x], text.data.apl2[img][y][x])
				elseif text.data.apl2[img][y][x] <= 70 then
						two = two .. string.sub(graphicsKey, text.data.apl2[img][y][x] - 35, text.data.apl2[img][y][x] - 35)
				elseif text.data.apl2[img][y][x] <= 105 then
						three = three .. string.sub(graphicsKey, text.data.apl2[img][y][x] - 70, text.data.apl2[img][y][x] - 70)
				else
						four = four .. string.sub(graphicsKey, text.data.apl2[img][y][x] - 105, text.data.apl2[img][y][x] - 105)
				end			
			end
			if one == "" and two == "" and three == "" and four == "" then
				table.insert(text.data.packed[img], "n")
			else table.insert(text.data.packed[img],one.."b"..two.."b"..three.."b"..four)
			end
		end
	end
	for y = 1, #text.data.input[3] do
		local one   = ""
		local two   = ""
		local three = ""
		local four  = ""
		local five  = "" 
		local six   = ""
		local seven = ""
		local eight = ""
		for x = 1, #text.data.apl2[3][y] do
			if text.data.apl2[3][y][x] <= 35 then
					one = one .. string.sub(graphicsKey, text.data.apl2[3][y][x], text.data.apl2[3][y][x])
			elseif text.data.apl2[3][y][x] <= 70 then
					two = two .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 35, text.data.apl2[3][y][x] - 35)
			elseif text.data.apl2[3][y][x] <= 105 then
					three = three .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 70, text.data.apl2[3][y][x] - 70)
			elseif text.data.apl2[3][y][x] <= 140 then
					four = four .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 105, text.data.apl2[3][y][x] - 105)
			elseif text.data.apl2[3][y][x] <=175 then
					five = five .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 140, text.data.apl2[3][y][x] -140)
			elseif text.data.apl2[3][y][x] <= 210 then
					six = six .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 175, text.data.apl2[3][y][x] - 175)
			elseif text.data.apl2[3][y][x] <= 245 then
					seven = seven .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 210, text.data.apl2[3][y][x] - 210)
			else
					eight = eight .. string.sub(graphicsKey, text.data.apl2[3][y][x] - 245, text.data.apl2[3][y][x] - 245)
			end			
		end
		if one == "" and two == "" and three == "" and four == "" and five == "" and six == "" and seven == "" and eight == "" then
			table.insert(text.data.packed[3], "n")
		else table.insert(text.data.packed[3],one.."b"..two.."b"..three.."b"..four.."b"..five.."b"..six.."b"..seven.."b"..eight)
		end
	end
end

text.sendIMG = function()
	for img = 1, 3 do
		for y = 1, #text.data.packed[img] do
			cmd.sjinn(text.data.packed[img][y])
		end
		cmd.sleep(2)
	end
end
